<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCashbackSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cashback_settings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('branch_id')->nullable(); // null means global setting
            $table->boolean('status')->default(0); // 1 = active, 0 = inactive
            $table->decimal('cashback_percentage', 8, 2)->default(0.00); // percentage of order value
            $table->decimal('minimum_order_amount', 8, 2)->default(0.00); // minimum order amount to get cashback
            $table->decimal('maximum_cashback_amount', 8, 2)->nullable(); // maximum cashback per order
            $table->boolean('wallet_discount_status')->default(1); // allow wallet discount usage
            $table->decimal('wallet_discount_max_percentage', 5, 2)->default(50.00); // max 50% of order can be paid from wallet
            $table->timestamps();

            $table->foreign('branch_id')->references('id')->on('branches')->onDelete('cascade');
            $table->index(['branch_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cashback_settings');
    }
}
