@extends('layouts.admin.app')

@section('title', translate('Cashback Management'))

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('admin.dashboard')}}">
                                {{translate('Dashboard')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{translate('Cashback Management')}}</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">{{translate('Cashback Management')}}</h1>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Global Settings -->
    <div class="card mb-3">
        <div class="card-header">
            <h4 class="mb-0">
                <i class="tio-settings-outlined"></i>
                {{translate('Global Cashback Settings')}}
            </h4>
        </div>
        <div class="card-body">
            @if($globalSetting)
            <form action="{{route('admin.cashback.update', $globalSetting->id)}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system globally')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status"
                                       value="1" {{$globalSetting->status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <input type="number" class="form-control" name="cashback_percentage"
                                   value="{{$globalSetting->cashback_percentage}}"
                                   step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <input type="number" class="form-control" name="minimum_order_amount"
                                   value="{{$globalSetting->minimum_order_amount}}"
                                   step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <input type="number" class="form-control" name="maximum_cashback_amount"
                                   value="{{$globalSetting->maximum_cashback_amount}}"
                                   step="0.01" min="0">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" {{$globalSetting->wallet_discount_status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                   value="{{$globalSetting->wallet_discount_max_percentage}}"
                                   step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                </div>
                <div class="btn-toolbar justify-content-end">
                    <button type="submit" class="btn btn-primary">{{translate('Update Global Settings')}}</button>
                </div>
            </form>
            @else
            <form action="{{route('admin.cashback.store')}}" method="post">
                @csrf
                <input type="hidden" name="branch_id" value="">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system globally')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status" value="1">
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <input type="number" class="form-control" name="cashback_percentage"
                                   value="0" step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <input type="number" class="form-control" name="minimum_order_amount"
                                   value="0" step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <input type="number" class="form-control" name="maximum_cashback_amount"
                                   step="0.01" min="0">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" checked>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                   value="50" step="0.01" min="0" max="100" required>
                        </div>
                    </div>
                </div>
                <div class="btn-toolbar justify-content-end">
                    <button type="submit" class="btn btn-primary">{{translate('Create Global Settings')}}</button>
                </div>
            </form>
            @endif
        </div>
    </div>

    <!-- Branch Settings -->
    <div class="card">
        <div class="card-header">
            <div class="row justify-content-between align-items-center flex-grow-1">
                <div class="col-sm-4 col-md-6 col-lg-8 mb-2 mb-sm-0">
                    <h4 class="d-flex align-items-center text-capitalize gap-10 mb-0">
                        <img width="20" class="avatar avatar-xs" src="{{asset('public/assets/admin/img/icons/branch.png')}}" alt="">
                        {{translate('Branch Specific Settings')}}
                    </h4>
                </div>
                <div class="col-sm-8 col-md-6 col-lg-4">
                    <button type="button" class="btn btn-primary float-right" data-toggle="modal" data-target="#branchModal">
                        <i class="tio-add-circle"></i>
                        {{translate('Add Branch Setting')}}
                    </button>
                </div>
            </div>
        </div>

        <div class="table-responsive datatable-custom">
            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                <thead class="thead-light">
                <tr>
                    <th>{{translate('Branch Name')}}</th>
                    <th>{{translate('Cashback Status')}}</th>
                    <th>{{translate('Cashback %')}}</th>
                    <th>{{translate('Min Order')}}</th>
                    <th>{{translate('Max Cashback')}}</th>
                    <th>{{translate('Wallet Discount')}}</th>
                    <th>{{translate('Max Wallet %')}}</th>
                    <th class="text-center">{{translate('Action')}}</th>
                </tr>
                </thead>

                <tbody>
                @forelse($branchSettings as $setting)
                <tr>
                    <td>
                        <span class="d-block font-size-sm text-body">
                            {{$setting->branch ? $setting->branch->name : translate('Deleted Branch')}}
                        </span>
                    </td>
                    <td>
                        <label class="switcher">
                            <input type="checkbox" class="switcher_input status"
                                   data-route="{{route('admin.cashback.status', [$setting->id, $setting->status ? 0 : 1])}}"
                                   {{$setting->status ? 'checked' : ''}}>
                            <span class="switcher_control"></span>
                        </label>
                    </td>
                    <td>{{$setting->cashback_percentage}}%</td>
                    <td>{{\App\CentralLogics\Helpers::set_symbol($setting->minimum_order_amount)}}</td>
                    <td>
                        {{$setting->maximum_cashback_amount ? \App\CentralLogics\Helpers::set_symbol($setting->maximum_cashback_amount) : translate('No Limit')}}
                    </td>
                    <td>
                        <span class="badge {{$setting->wallet_discount_status ? 'badge-success' : 'badge-danger'}}">
                            {{$setting->wallet_discount_status ? translate('Enabled') : translate('Disabled')}}
                        </span>
                    </td>
                    <td>{{$setting->wallet_discount_max_percentage}}%</td>
                    <td>
                        <div class="dropdown">
                            <button class="btn btn-outline-secondary dropdown-toggle" type="button"
                                    id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                    aria-expanded="false">
                                <i class="tio-settings"></i>
                            </button>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" href="{{route('admin.cashback.edit', $setting->id)}}">
                                    <i class="tio-edit"></i> {{translate('Edit')}}
                                </a>
                                <a class="dropdown-item" href="javascript:"
                                   onclick="form_alert('cashback-{{$setting->id}}','Want to delete this cashback setting ?')">
                                    <i class="tio-delete-outlined"></i> {{translate('Delete')}}
                                </a>
                            </div>
                        </div>
                        <form action="{{route('admin.cashback.delete', $setting->id)}}" method="post" id="cashback-{{$setting->id}}">
                            @csrf
                            @method('delete')
                        </form>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="text-center">
                        <img class="mb-3 w-160" src="{{asset('public/assets/admin/svg/illustrations/sorry.svg')}}" alt="Image Description">
                        <p class="mb-0">{{translate('No branch settings found')}}</p>
                    </td>
                </tr>
                @endforelse
                </tbody>
            </table>
        </div>

        @if($branchSettings->count() > 0)
        <div class="card-footer">
            {{$branchSettings->links()}}
        </div>
        @endif
    </div>

    <!-- Branch Setting Modal -->
    <div class="modal fade" id="branchModal" tabindex="-1" role="dialog" aria-labelledby="branchModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="branchModalLabel">{{translate('Add Branch Cashback Setting')}}</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="{{route('admin.cashback.store')}}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Branch')}}</label>
                                    <select name="branch_id" class="form-control" required>
                                        <option value="">{{translate('Select Branch')}}</option>
                                        @foreach($branches as $branch)
                                        <option value="{{$branch->id}}">{{$branch->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Cashback Status')}}</label>
                                    <label class="switcher">
                                        <input type="checkbox" class="switcher_input" name="status" value="1">
                                        <span class="switcher_control"></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                                    <input type="number" class="form-control" name="cashback_percentage"
                                           value="0" step="0.01" min="0" max="100" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                                    <input type="number" class="form-control" name="minimum_order_amount"
                                           value="0" step="0.01" min="0" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                                    <input type="number" class="form-control" name="maximum_cashback_amount"
                                           step="0.01" min="0">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Wallet Discount Status')}}</label>
                                    <label class="switcher">
                                        <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                               value="1" checked>
                                        <span class="switcher_control"></span>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                                    <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                           value="50" step="0.01" min="0" max="100" required>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{translate('Close')}}</button>
                        <button type="submit" class="btn btn-primary">{{translate('Add Setting')}}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).on('change', '.status', function () {
    let route = $(this).data('route');
    location.href = route;
});
</script>
@endsection
