@extends('layouts.branch.app')

@section('title', translate('Cashback Settings'))

@section('content')
<div class="content container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col-sm mb-2 mb-sm-0">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb breadcrumb-no-gutter">
                        <li class="breadcrumb-item">
                            <a class="breadcrumb-link" href="{{route('branch.dashboard')}}">
                                {{translate('Dashboard')}}
                            </a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">{{translate('Cashback Settings')}}</li>
                    </ol>
                </nav>
                <h1 class="page-header-title">{{translate('Cashback Settings')}}</h1>
            </div>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Branch Settings -->
    <div class="card">
        <div class="card-header">
            <h4 class="mb-0">
                <i class="tio-settings-outlined"></i>
                {{translate('Branch Cashback Settings')}} - {{$branch->name}}
            </h4>
        </div>
        <div class="card-body">
            @if($cashbackSetting)
            <form action="{{route('branch.cashback.update')}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system for your branch')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status"
                                       value="1" {{$cashbackSetting->status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <input type="number" class="form-control" name="cashback_percentage"
                                   value="{{$cashbackSetting->cashback_percentage}}"
                                   step="0.01" min="0" max="100" required>
                            <small class="form-text text-muted">{{translate('Percentage of order amount to give as cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <input type="number" class="form-control" name="minimum_order_amount"
                                   value="{{$cashbackSetting->minimum_order_amount}}"
                                   step="0.01" min="0" required>
                            <small class="form-text text-muted">{{translate('Minimum order value to earn cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <input type="number" class="form-control" name="maximum_cashback_amount"
                                   value="{{$cashbackSetting->maximum_cashback_amount}}"
                                   step="0.01" min="0">
                            <small class="form-text text-muted">{{translate('Maximum cashback limit per order (leave empty for no limit)')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" {{$cashbackSetting->wallet_discount_status ? 'checked' : ''}}>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                   value="{{$cashbackSetting->wallet_discount_max_percentage}}"
                                   step="0.01" min="0" max="50" required>
                            <small class="form-text text-muted">{{translate('Maximum wallet balance usable as discount (up to 50%)')}}</small>
                        </div>
                    </div>
                </div>

                <!-- Current Settings Display -->
                <div class="row mt-4">
                    <div class="col-12">
                        <div class="alert alert-info">
                            <h6 class="mb-2">{{translate('Current Settings Summary')}}</h6>
                            <ul class="mb-0">
                                <li><strong>{{translate('Cashback')}}:</strong>
                                    {{$cashbackSetting->status ? translate('Active') : translate('Inactive')}} -
                                    {{$cashbackSetting->cashback_percentage}}% {{translate('on orders above')}}
                                    {{\App\CentralLogics\Helpers::set_symbol($cashbackSetting->minimum_order_amount)}}
                                </li>
                                <li><strong>{{translate('Wallet Discount')}}:</strong>
                                    {{$cashbackSetting->wallet_discount_status ? translate('Enabled') : translate('Disabled')}} -
                                    {{translate('Up to')}} {{$cashbackSetting->wallet_discount_max_percentage}}% {{translate('of order value')}}
                                </li>
                                @if($cashbackSetting->maximum_cashback_amount)
                                <li><strong>{{translate('Max Cashback')}}:</strong>
                                    {{\App\CentralLogics\Helpers::set_symbol($cashbackSetting->maximum_cashback_amount)}} {{translate('per order')}}
                                </li>
                                @endif
                            </ul>
                        </div>
                    </div>
                </div>

                <div class="btn-toolbar justify-content-end">
                    <button type="submit" class="btn btn-primary">{{translate('Update Cashback Settings')}}</button>
                </div>
            </form>
            @else
            <div class="alert alert-warning">
                <h6>{{translate('No Cashback Settings Found')}}</h6>
                <p class="mb-0">{{translate('You need to create cashback settings for your branch to enable cashback and wallet discount features.')}}</p>
            </div>
            <form action="{{route('branch.cashback.store')}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Enable or disable cashback system for your branch')}}">
                                    </i>
                                </span>
                                {{translate('Cashback Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="status" value="1" checked>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Cashback Percentage')}} (%)</label>
                            <input type="number" class="form-control" name="cashback_percentage"
                                   value="5" step="0.01" min="0" max="100" required>
                            <small class="form-text text-muted">{{translate('Percentage of order amount to give as cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Minimum Order Amount')}}</label>
                            <input type="number" class="form-control" name="minimum_order_amount"
                                   value="100" step="0.01" min="0" required>
                            <small class="form-text text-muted">{{translate('Minimum order value to earn cashback')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Cashback Amount')}} ({{translate('Optional')}})</label>
                            <input type="number" class="form-control" name="maximum_cashback_amount"
                                   value="100" step="0.01" min="0">
                            <small class="form-text text-muted">{{translate('Maximum cashback limit per order (leave empty for no limit)')}}</small>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label d-flex align-items-center">
                                <span class="input-label-secondary text--title">
                                    <i class="tio-info-outlined"
                                       data-toggle="tooltip"
                                       data-placement="right"
                                       title="{{translate('Allow customers to use wallet balance for discounts')}}">
                                    </i>
                                </span>
                                {{translate('Wallet Discount Status')}}
                            </label>
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input" name="wallet_discount_status"
                                       value="1" checked>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="input-label">{{translate('Maximum Wallet Discount')}} (%)</label>
                            <input type="number" class="form-control" name="wallet_discount_max_percentage"
                                   value="50" step="0.01" min="0" max="50" required>
                            <small class="form-text text-muted">{{translate('Maximum wallet balance usable as discount (up to 50%)')}}</small>
                        </div>
                    </div>
                </div>
                <div class="btn-toolbar justify-content-end">
                    <button type="submit" class="btn btn-primary">{{translate('Create Cashback Settings')}}</button>
                </div>
            </form>
            @endif
        </div>
    </div>

    <!-- Quick Actions -->
    @if($cashbackSetting)
    <div class="row mt-3">
        <div class="col-md-6">
            <div class="card">
                <div class="card-body text-center">
                    <i class="tio-toggle text-primary" style="font-size: 2rem;"></i>
                    <h6 class="mt-2">{{translate('Quick Status Toggle')}}</h6>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-sm btn-outline-success status-toggle"
                                data-status="1" data-type="cashback"
                                {{$cashbackSetting->status ? 'disabled' : ''}}>
                            {{translate('Enable Cashback')}}
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-danger status-toggle"
                                data-status="0" data-type="cashback"
                                {{!$cashbackSetting->status ? 'disabled' : ''}}>
                            {{translate('Disable Cashback')}}
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card">
                <div class="card-body text-center">
                    <i class="tio-wallet text-info" style="font-size: 2rem;"></i>
                    <h6 class="mt-2">{{translate('Wallet Discount Toggle')}}</h6>
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-sm btn-outline-success status-toggle"
                                data-status="1" data-type="wallet"
                                {{$cashbackSetting->wallet_discount_status ? 'disabled' : ''}}>
                            {{translate('Enable Wallet')}}
                        </button>
                        <button type="button" class="btn btn-sm btn-outline-danger status-toggle"
                                data-status="0" data-type="wallet"
                                {{!$cashbackSetting->wallet_discount_status ? 'disabled' : ''}}>
                            {{translate('Disable Wallet')}}
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif
</div>

<script>
$(document).ready(function() {
    $('.status-toggle').click(function() {
        let status = $(this).data('status');
        let type = $(this).data('type');
        let route = type === 'cashback' ?
            '{{route("branch.cashback.status")}}' :
            '{{route("branch.cashback.wallet-discount-status")}}';

        $.ajax({
            url: route,
            type: 'GET',
            data: {status: status},
            success: function(response) {
                if(response.success) {
                    toastr.success(response.message);
                    setTimeout(() => location.reload(), 1000);
                } else {
                    toastr.error(response.message);
                }
            },
            error: function() {
                toastr.error('{{translate("Something went wrong")}}');
            }
        });
    });

    $('[data-toggle="tooltip"]').tooltip();
});
</script>
@endsection
