<?php $__env->startSection('title', translate('Update banner')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/banner.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Update_Banner')); ?>

                </span>
            </h2>
        </div>

        <div class="row gx-2 gx-lg-3">
            <div class="col-sm-12 col-lg-12 mb-3 mb-lg-2">
                <form action="<?php echo e(route('admin.banner.update',[$banner['id']])); ?>" method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?> <?php echo method_field('put'); ?>

                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('title')); ?><span class="text-danger ml-1">*</span></label>
                                        <input type="text" name="title" value="<?php echo e($banner['title']); ?>" class="form-control"
                                            placeholder="<?php echo e(translate('New banner')); ?>" required>
                                    </div>
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('item_Type')); ?><span class="text-danger ml-1">*</span></label>
                                        <select name="item_type" class="custom-select">
                                            <option value="product" <?php echo e($banner['product_id']==null?'':'selected'); ?>><?php echo e(translate('product')); ?></option>
                                            <option value="category" <?php echo e($banner['category_id']==null?'':'selected'); ?>><?php echo e(translate('category')); ?></option>
                                        </select>
                                    </div>
                                    <div class="form-group" id="type-product" style="display: <?php echo e($banner['product_id']==null?'none':'block'); ?>">
                                        <label class="input-label"><?php echo e(translate('product')); ?> <span class="text-danger ml-1">*</span></label>
                                        <select name="product_id" class="custom-select">
                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($product['id']); ?>" <?php echo e($banner['product_id']==$product['id']?'selected':''); ?>><?php echo e($product['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="form-group" id="type-category" style="display: <?php echo e($banner['category_id']==null?'none':'block'); ?>">
                                        <label class="input-label"><?php echo e(translate('category')); ?> <span class="text-danger ml-1">*</span></label>
                                        <select name="category_id" class="form-control js-select2-custom">
                                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($category['id']); ?>" <?php echo e($banner['category_id']==$category['id']?'selected':''); ?>><?php echo e($category['name']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <div class="d-flex align-items-center justify-content-center gap-1">
                                            <label class="mb-0"><?php echo e(translate('banner_Image')); ?></label>
                                            <small class="text-danger">* ( <?php echo e(translate('ratio 2:1')); ?> )</small>
                                        </div>
                                        <div class="d-flex justify-content-center mt-4">
                                            <div class="upload-file">
                                                <input type="file" name="image" accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*" class="upload-file__input">
                                                <div class="upload-file__img_drag upload-file__img max-h-200px overflow-hidden">
                                                    <img width="465" src="<?php echo e($banner->imageFullPath); ?>"
                                                         alt="<?php echo e(translate('banner image')); ?>"/>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex justify-content-end gap-3 mt-4">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn-primary"><?php echo e(translate('update')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $("select[name='item_type']").change(function() {
            var selectedValue = $(this).val();
            show_item(selectedValue);
        });

        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();

                reader.onload = function (e) {
                    $('#viewer').attr('src', e.target.result);
                }

                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this);
        });

        function show_item(type) {
            if (type === 'product') {
                $("#type-product").show();
                $("#type-category").hide();
            } else {
                $("#type-product").hide();
                $("#type-category").show();
            }
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/banner/edit.blade.php ENDPATH**/ ?>