<?php $__env->startSection('title', translate('Product List')); ?>

<?php $__env->startPush('css_or_js'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/product.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Product_List')); ?>

                </span>
            </h2>
            <span class="badge badge-soft-dark rounded-50 fz-14"><?php echo e($products->total()); ?></span>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-top px-card pt-4">
                        <div class="row justify-content-between align-items-center gy-2">
                            <div class="col-lg-4">
                                <form action="<?php echo e(url()->current()); ?>" method="GET">
                                    <div class="input-group">
                                        <input id="datatableSearch_" type="search" name="search" class="form-control" placeholder="<?php echo e(translate('search_by_product_name')); ?>" aria-label="Search" value="<?php echo e($search); ?>" required="" autocomplete="off">
                                        <div class="input-group-append">
                                            <button type="submit" class="btn btn-primary"><?php echo e(translate('Search')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="py-4">
                        <div class="table-responsive datatable-custom">
                            <table class="table table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                                <thead class="thead-light">
                                <tr>
                                    <th><?php echo e(translate('SL')); ?></th>
                                    <th><?php echo e(translate('product_name')); ?></th>
                                    <th><?php echo e(translate('selling_price')); ?></th>
                                    <th class="text-center"><?php echo e(translate('total_sale')); ?></th>
                                    <th><?php echo e(translate('stock')); ?></th>
                                    <th><?php echo e(translate('Availability')); ?></th>
                                    <th class="text-center"><?php echo e(translate('update_price')); ?></th>
                                </tr>
                                </thead>

                                <tbody id="set-rows">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($products->firstitem()+$key); ?></td>
                                        <td>
                                            <div class="media align-items-center gap-3">
                                                <div class="avatar">
                                                    <img src="<?php echo e($product['imageFullPath']); ?>" class="rounded img-fit" alt="<?php echo e(translate('product')); ?>">
                                                </div>
                                                <div class="media-body">
                                                        <?php echo e(Str::limit($product['name'], 30)); ?>

                                                </div>
                                            </div>
                                        </td>

                                        <?php ($productByBranch = json_decode($product->product_by_branch, true)); ?>
                                        <?php if(isset($productByBranch[0])): ?>
                                            <td><?php echo e(Helpers::set_symbol($productByBranch[0]['price'])); ?></td>
                                        <?php else: ?>
                                            <td><?php echo e(Helpers::set_symbol($product['price'])); ?></td>
                                        <?php endif; ?>
                                        <td class="text-center"><?php echo e(\App\Model\OrderDetail::whereHas('order', function ($q){
                                                    $q->where('order_status', 'delivered')
                                                        ->where('branch_id',  auth('branch')->id());
                                                })->where('product_id', $product->id)->sum('quantity')); ?>

                                        </td>
                                        <td>
                                            <div><span class=""><?php echo e(translate('Stock Type')); ?> : <?php echo e(ucfirst($product->sub_branch_product?->stock_type)); ?></span></div>
                                            <?php if(isset($product->sub_branch_product) && $product->sub_branch_product->stock_type != 'unlimited'): ?>
                                                <div><span class=""><?php echo e(translate('Stock')); ?> : <?php echo e($product->sub_branch_product->stock - $product->sub_branch_product->sold_quantity); ?></span></div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div>
                                                <label class="switcher">
                                                    <?php $__empty_1 = true; $__currentLoopData = $product->product_by_branch; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                        <input id="<?php echo e($product['id']); ?>" class="switcher_input"
                                                            type="checkbox" <?php echo e(($item->product_id == $product->id) && $item->is_available == 1 ? 'checked' : ''); ?>

                                                            data-url="<?php echo e(route('branch.product.status',[$product['id'],0])); ?>" onchange="status_change(this)">
                                                        <span class="switcher_control"></span>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                        <input id="<?php echo e($product['id']); ?>" class="switcher_input" type="checkbox"
                                                            data-url="<?php echo e(route('branch.product.status',[$product['id'],0])); ?>" onchange="status_change(this)">
                                                        <span class="switcher_control"></span>
                                                    <?php endif; ?>
                                                </label>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a class="btn btn-outline-info btn-sm edit square-btn"
                                                    href="<?php echo e(route('branch.product.set-price',[$product['id']])); ?>"><i class="tio-edit"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="table-responsive mt-4 px-3">
                            <div class="d-flex justify-content-lg-end">
                                <?php echo $products->links(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict"

        $('#search-form').on('submit', function () {
            var formData = new FormData(this);
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.post({
                url: '<?php echo e(route('admin.product.search')); ?>',
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $('#loading').show();
                },
                success: function (data) {
                    $('#set-rows').html(data.view);
                    $('.page-area').hide();
                },
                complete: function () {
                    $('#loading').hide();
                },
            });
        });

        function status_change(t) {
            let url = $(t).data('url');
            let checked = $(t).prop("checked");
            let status = checked === true ? 1 : 0;

            Swal.fire({
                title: 'Are you sure?',
                text: 'Want to change status',
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#FC6A57',
                cancelButtonColor: 'default',
                cancelButtonText: '<?php echo e(translate("No")); ?>',
                confirmButtonText: '<?php echo e(translate("Yes")); ?>',
                reverseButtons: true
            }).then((result) => {
                    if (result.value) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="_token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: url,
                            data: {
                                status: status
                            },
                            success: function (data, status) {

                                if(data.variation_message !== undefined ){
                                    toastr.error(data.variation_message);

                                }
                                if(data.success_message !== undefined ){
                                    toastr.success(data.success_message);

                                }
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);

                            },
                            error: function (data) {
                                toastr.error("<?php echo e(translate('Status changed failed')); ?>");
                            },
                        });
                    }

                    else if (result.dismiss) {
                        if (status == 1) {
                            $('#' + t.id).prop('checked', false)

                        } else if (status == 0) {
                            $('#'+ t.id).prop('checked', true)
                        }
                        toastr.info("<?php echo e(translate("Status hasn't changed")); ?>");
                    }
                }
            )
        }
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/branch-views/product/list.blade.php ENDPATH**/ ?>