<?php $__env->startSection('title', translate('Update Addon')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/attribute.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('Addon_Update')); ?>

                </span>
            </h2>
        </div>

        <div class="row g-3">
            <div class="col-12">
                <div class="card card-body">
                    <form action="<?php echo e(route('admin.addon.update',[$addon['id']])); ?>" method="post">
                        <?php echo csrf_field(); ?>

                        <?php ($data = Helpers::get_business_settings('language')); ?>
                        <?php ($defaultLang = Helpers::get_default_language()); ?>

                        <?php if($data && array_key_exists('code', $data[0])): ?>
                            <ul class="nav nav-tabs w-fit-content mb-4">
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link lang_link <?php echo e($lang['default'] == true ? 'active':''); ?>" href="#" id="<?php echo e($lang['code']); ?>-link"><?php echo e(Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="row">
                                <div class="col-sm-12">
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        if(count($addon['translations'])){
                                            $translate = [];
                                            foreach($addon['translations'] as $t)
                                            {
                                                if($t->locale == $lang['code'] && $t->key=="name"){
                                                    $translate[$lang['code']]['name'] = $t->value;
                                                }
                                            }
                                        }
                                        ?>
                                            <div class="form-group <?php echo e($lang['default'] == false ? 'd-none':''); ?> lang_form" id="<?php echo e($lang['code']); ?>-form">
                                                <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?> (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                                <input type="text" name="name[]"
                                                    class="form-control"
                                                    placeholder="<?php echo e(translate('New Addon')); ?>"
                                                    value="<?php echo e($lang['code'] == 'en' ? $addon['name']:($translate[$lang['code']]['name']??'')); ?>"
                                                    <?php echo e($lang['status'] == true ? 'required':''); ?> maxlength="255"
                                                    <?php if($lang['status'] == true): ?> oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>>
                                            </div>
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="row">
                                            <div class="col-sm-12">
                                                <div class="form-group lang_form" id="<?php echo e($defaultLang); ?>-form">
                                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('name')); ?> (<?php echo e(strtoupper($defaultLang)); ?>)</label>
                                                    <input type="text" name="name[]" value="<?php echo e($addon['name']); ?>" class="form-control" placeholder="<?php echo e(translate('New Addon')); ?>" required maxlength="255">
                                                </div>
                                                <input type="hidden" name="lang[]" value="<?php echo e($defaultLang); ?>">
                                                <?php endif; ?>
                                                <input name="position" class="position-area" value="0">
                                            </div>
                                            <div class="col-sm-6 from_part_2">
                                                <div class="form-group">
                                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('price')); ?></label>
                                                    <input type="number" min="0" step="any" name="price"
                                                        value="<?php echo e($addon['price']); ?>" class="form-control"
                                                        placeholder="200" required
                                                        oninvalid="document.getElementById('en-link').click()">
                                                </div>
                                            </div>
                                            <div class="col-sm-6 from_part_2">
                                                <div class="form-group">
                                                    <label class="input-label" for="exampleFormControlInput1"><?php echo e(translate('tax')); ?> (%)</label>
                                                    <input type="number" min="0" step="any" name="tax"
                                                           value="<?php echo e($addon['tax']); ?>" class="form-control"
                                                           placeholder="5" required
                                                           oninvalid="document.getElementById('en-link').click()">
                                                </div>
                                            </div>
                                            <div class="col-12 mb-2">
                                                <div class="d-flex justify-content-end gap-3">
                                                    <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                                    <button type="submit" class="btn btn-primary"><?php echo e(translate('update')); ?></button>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        $(".lang_link").click(function(e){
            e.preventDefault();
            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];
            $("#"+lang+"-form").removeClass('d-none');

            if(lang == '<?php echo e($defaultLang); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/addon/edit.blade.php ENDPATH**/ ?>