<?php $__env->startSection('title',''); ?>

<?php $__env->startPush('css_or_js'); ?>
    <style>
        @media print {
            .non-printable {
                display: none;
            }

            .printable {
                display: block;
            }
        }

        .hr-style-2 {
            border: 0;
            height: 1px;
            background-image: linear-gradient(to right, rgba(0, 0, 0, 0), rgba(0, 0, 0, 0.75), rgba(0, 0, 0, 0));
        }

        .hr-style-1 {
            overflow: visible;
            padding: 0;
            border: none;
            border-top: medium double #000000;
            text-align: center;
        }
        #printableAreaContent * {
            font-weight: normal !important;
        }
    </style>

    <style type="text/css" media="print">
        @page {
            size: auto;   /* auto is the initial value */
            margin: 2px;
        }

    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="content container-fluid" style="color: black">
        <div class="row justify-content-center" id="printableArea">
            <div class="col-md-12">
                <div class="text-center">
                    <input type="button" class="btn btn-primary non-printable" onclick="printDiv('printableArea')"
                           value="<?php echo e(translate('Proceed, If thermal printer is ready.')); ?>"/>
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger non-printable"><?php echo e(translate('Back')); ?></a>
                </div>
                <hr class="non-printable">
            </div>
            <div class="col-5" id="printableAreaContent">
                <div class="text-center pt-4 mb-3">
                    <h2 style="line-height: 1"><?php echo e(\App\Model\BusinessSetting::where(['key'=>'restaurant_name'])->first()->value); ?></h2>
                    <h5 style="font-size: 20px;font-weight: lighter;line-height: 1">
                         <?php echo e($order->branch?->address); ?>

                    </h5>
                    <h5 style="font-size: 16px;font-weight: lighter;line-height: 1">
                        Phone : <?php echo e($order->branch?->phone); ?>

                    </h5>
                </div>
                <hr class="text-dark hr-style-1">

                <div class="row mt-4">
                    <div class="col-6">
                        <h5><?php echo e(translate('Order ID : ')); ?><?php echo e($order['id']); ?></h5>
                    </div>
                    <div class="col-6">
                        <h5 style="font-weight: lighter">
                            <span class="font-weight-normal"><?php echo e(date('d M Y',strtotime($order['created_at']))); ?> <?php echo e(date(config('time_format'), strtotime($order['created_at']))); ?></span>
                        </h5>
                    </div>
                    <div class="col-12">
                        <?php if($order->is_guest == 0): ?>
                            <?php if(isset($order->customer)): ?>
                                <h5>
                                    <?php echo e(translate('Customer Name : ')); ?><span class="font-weight-normal"><?php echo e($order->customer['f_name'].' '.$order->customer['l_name']); ?></span>
                                </h5>
                                <h5>
                                    <?php echo e(translate('Phone : ')); ?><span class="font-weight-normal"><?php echo e($order->customer['phone']); ?></span>
                                </h5>
                                <?php ($address=\App\Model\CustomerAddress::find($order['delivery_address_id'])); ?>
                                <h5>
                                    <?php echo e(translate('Address : ')); ?><span class="font-weight-normal">(<?php echo e($address['floor'] ?? ''); ?>,<?php echo e($address['house'] ?? ''); ?>,<?php echo e($address['road'] ?? ''); ?>) <?php echo e(isset($address)?$address['address']:''); ?></span>
                                </h5>
                            <?php endif; ?>
                        <?php endif; ?>
                        <?php if($order->is_guest == 1): ?>
                            <?php if($order->order_type == 'delivery'): ?>
                                    <?php if(isset($order->delivery_address)): ?>
                                        <h5>
                                            <?php echo e(translate('Customer Name : ')); ?><span class="font-weight-normal"><?php echo e($order->delivery_address['contact_person_name']); ?></span>
                                        </h5>
                                        <h5>
                                            <?php echo e(translate('Phone : ')); ?><span class="font-weight-normal"><?php echo e($order->delivery_address['contact_person_number']); ?></span>
                                        </h5>
                                        <h5>
                                            <?php echo e(translate('Address : ')); ?><span class="font-weight-normal"><?php echo e($order->delivery_address['address']); ?></span>
                                        </h5>
                                    <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <h5 class="text-uppercase"></h5>
                <hr class="text-dark hr-style-2">
                <table class="table table-bordered mt-3">
                    <thead>
                    <tr>
                        <th style="width: 10%"><?php echo e(translate('QTY')); ?></th>
                        <th class=""><?php echo e(translate('DESC')); ?></th>
                        <th style="text-align:right; padding-right:4px"><?php echo e(translate('Price')); ?></th>
                    </tr>
                    </thead>

                    <tbody>
                    <?php ($subTotal=0); ?>
                    <?php ($totalTax=0); ?>
                    <?php ($totalDisOnPro=0); ?>
                    <?php ($addOnsCost=0); ?>
                    <?php ($addOnTax=0); ?>
                    <?php ($add_ons_tax_cost=0); ?>
                    <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($detail->product): ?>
                            <?php ($addOnQtys=json_decode($detail['add_on_qtys'],true)); ?>
                            <?php ($addOnPrices=json_decode($detail['add_on_prices'],true)); ?>
                            <?php ($addOnTaxes=json_decode($detail['add_on_taxes'],true)); ?>

                            <tr>
                                <td class="">
                                    <?php echo e($detail['quantity']); ?>

                                </td>
                                <td class="">
                                    <span style="word-break: break-all;"> <?php echo e(Str::limit($detail->product['name'], 200)); ?></span><br>
                                    <?php if(count(json_decode($detail['variation'], true)) > 0): ?>
                                        <strong><u><?php echo e(translate('variation')); ?> : </u></strong>
                                        <?php $__currentLoopData = json_decode($detail['variation'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if( isset($variation['name'])  && isset($variation['values'])): ?>
                                                <span class="d-block text-capitalize">
                                                    <strong><?php echo e($variation['name']); ?> - </strong>
                                                </span>
                                                <?php $__currentLoopData = $variation['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="d-block text-capitalize">
                                                        <?php echo e($value['label']); ?> :
                                                        <strong><?php echo e(\App\CentralLogics\Helpers::set_symbol( $value['optionPrice'])); ?></strong>
                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <?php if(isset(json_decode($detail['variation'],true)[0])): ?>
                                                    <?php $__currentLoopData = json_decode($detail['variation'],true)[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="font-size-sm text-body">
                                                            <span><?php echo e($key1); ?> :  </span>
                                                            <span class="font-weight-bold"><?php echo e($variation); ?></span>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                <?php break; ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <div class="font-size-sm text-body">
                                            <span><?php echo e(translate('Price')); ?> : </span>
                                            <span
                                                class="font-weight-bold"><?php echo e(\App\CentralLogics\Helpers::set_symbol($detail->price)); ?></span>
                                        </div>
                                    <?php endif; ?>


                                    <?php $__currentLoopData = json_decode($detail['add_on_ids'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 =>$id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php ($addon=\App\Model\AddOn::find($id)); ?>
                                        <?php if($key2==0): ?><strong><u><?php echo e(translate('Addons : ')); ?></u></strong><?php endif; ?>

                                        <?php if($addOnQtys==null): ?>
                                            <?php ($add_on_qty=1); ?>
                                        <?php else: ?>
                                            <?php ($add_on_qty=$addOnQtys[$key2]); ?>
                                        <?php endif; ?>

                                        <div class="font-size-sm text-body">
                                            <span><?php echo e($addon ? $addon['name'] : translate('addon deleted')); ?> :  </span>
                                            <span class="font-weight-bold">
                                                <?php echo e($add_on_qty); ?> x <?php echo e(\App\CentralLogics\Helpers::set_symbol($addOnPrices[$key2])); ?>

                                            </span>
                                        </div>
                                        <?php ($addOnsCost+=$addOnPrices[$key2] * $add_on_qty); ?>
                                        <?php ($add_ons_tax_cost +=  $addOnTaxes[$key2] * $add_on_qty); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php echo e(translate('Discount : ')); ?><?php echo e(\App\CentralLogics\Helpers::set_symbol($detail['discount_on_product'])); ?>

                                </td>
                                <td style="width: 28%;padding-right:4px; text-align:right">
                                    <?php ($amount=($detail['price']-$detail['discount_on_product'])*$detail['quantity']); ?>
                                    <?php echo e(\App\CentralLogics\Helpers::set_symbol($amount)); ?>

                                </td>
                            </tr>
                            <?php ($subTotal+=$amount); ?>
                            <?php ($totalTax+=($detail['tax_amount']*$detail['quantity']) ); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>


                <div class="row justify-content-md-end mb-3 m-0" style="width: 99%">
                    <div class="col-md-10 p-0">
                        <dl class="row text-right" style="color: black!important;">
                            <dt class="col-6"><?php echo e(translate('Items Price:')); ?></dt>
                            <dd class="col-6"><?php echo e(\App\CentralLogics\Helpers::set_symbol($subTotal)); ?></dd>
                            <dt class="col-6"><?php echo e(translate('Tax:')); ?></dt>
                            <dd class="col-6"><?php echo e(\App\CentralLogics\Helpers::set_symbol($totalTax + $add_ons_tax_cost)); ?></dd>
                            <dt class="col-6"><?php echo e(translate('Addon Cost:')); ?></dt>
                            <dd class="col-6">
                                <?php echo e(\App\CentralLogics\Helpers::set_symbol($addOnsCost)); ?>

                                <hr>
                            </dd>

                            <dt class="col-6"><?php echo e(translate('Subtotal:')); ?></dt>
                            <dd class="col-6">
                                <?php echo e(\App\CentralLogics\Helpers::set_symbol($subTotal+$totalTax+$addOnsCost+$add_ons_tax_cost)); ?></dd>
                            <dt class="col-6"><?php echo e(translate('Extra Discount')); ?>:</dt>
                            <dd class="col-6">
                                - <?php echo e(\App\CentralLogics\Helpers::set_symbol($order['extra_discount'])); ?></dd>
                            <dt class="col-6"><?php echo e(translate('Coupon Discount:')); ?></dt>
                            <dd class="col-6">
                                - <?php echo e(\App\CentralLogics\Helpers::set_symbol($order['coupon_discount_amount'])); ?></dd>
                            <dt class="col-6"><?php echo e(translate('Delivery Fee:')); ?></dt>
                            <dd class="col-6">
                                <?php if($order['order_type']=='take_away'): ?>
                                    <?php ($del_c=0); ?>
                                <?php else: ?>
                                    <?php ($del_c=$order['delivery_charge']); ?>
                                <?php endif; ?>
                                <?php echo e(\App\CentralLogics\Helpers::set_symbol($del_c)); ?>

                                <hr>
                            </dd>

                            <dt class="col-6" style="font-size: 20px"><?php echo e(translate('Total:')); ?></dt>
                            <dd class="col-6" style="font-size: 20px"><?php echo e(\App\CentralLogics\Helpers::set_symbol($subTotal+$del_c+$totalTax+$addOnsCost-$order['coupon_discount_amount']-$order['extra_discount']+$add_ons_tax_cost)); ?></dd>

                            <!-- partial payment-->
                            <?php if($order->order_partial_payments->isNotEmpty()): ?>
                                <?php $__currentLoopData = $order->order_partial_payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <dt class="col-6">
                                        <div class="">
                                            <span>
                                                <?php echo e(translate('Paid By')); ?> (<?php echo e(str_replace('_', ' ',$partial->paid_with)); ?>)</span>
                                            <span>:</span>
                                        </div>
                                    </dt>
                                    <dd class="col-6 text-dark text-right">
                                        <?php echo e(\App\CentralLogics\Helpers::set_symbol($partial->paid_amount)); ?>

                                    </dd>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    $due_amount = 0;
                                    $due_amount = $order->order_partial_payments->first()?->due_amount;
                                    ?>
                                <dt class="col-6">
                                    <div class="">
                                            <span>
                                                <?php echo e(translate('Due Amount')); ?></span>
                                        <span>:</span>
                                    </div>
                                </dt>
                                <dd class="col-6 text-dark text-right">
                                    <?php echo e(\App\CentralLogics\Helpers::set_symbol($due_amount)); ?>

                                </dd>
                            <?php endif; ?>
                        </dl>
                    </div>
                </div>
                <hr class="text-dark hr-style-2">
                <h5 class="text-center pt-3">
                    <?php echo e(translate('"""THANK YOU"""')); ?>

                </h5>
                <hr class="text-dark hr-style-2">
                <div class="text-center"><?php echo e(\App\Model\BusinessSetting::where(['key'=>'footer_text'])->first()->value); ?></div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function printDiv(divName) {

            if($('html').attr('dir') === 'rtl') {
                $('html').attr('dir', 'ltr')
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                $('#printableAreaContent').attr('dir', 'rtl')
                window.print();
                document.body.innerHTML = originalContents;
                $('html').attr('dir', 'rtl')
            }else{
                var printContents = document.getElementById(divName).innerHTML;
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                window.print();
                document.body.innerHTML = originalContents;
            }

        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/order/invoice.blade.php ENDPATH**/ ?>