<?php $__env->startSection('title', translate('Chat')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/third-party.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('third_party')); ?>

                </span>
            </h2>
        </div>

        <?php echo $__env->make('admin-views.business-settings.partials._3rdparty-inline-menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="row g-2">
            <div class="col-md-6">
                <div class="card">
                    <?php ($config=\App\CentralLogics\Helpers::get_business_settings('whatsapp')); ?>
                    <?php if($config): ?>
                        <form action="<?php echo e(env('APP_MODE')!='demo'?route('admin.business-settings.web-app.third-party.chat-update',['whatsapp']):'javascript:'); ?>"
                            method="post">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <h5 class="mb-4"><?php echo e(translate('Whatsapp')); ?></h5>
                                    <label class="switcher">
                                        <input class="switcher_input" name="status" type="checkbox" <?php echo e($config['status'] == 1? 'checked' : ''); ?>>

                                        <span class="switcher_control"></span>
                                    </label>
                                </div>

                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label><?php echo e(translate('number')); ?> <span class="text-danger">(<?php echo e(translate('without country code')); ?>)</span></label><br>
                                    <input type="text" class="form-control" name="number"
                                           value="<?php echo e($config['number'] ?? ''); ?>" placeholder="<?php echo e(translate('WhatsApp Number')); ?>">
                                </div>
                                <div class="btn--container">
                                    <button type="<?php echo e(env('APP_MODE')!='demo'?'submit':'button'); ?>"
                                            class="btn btn-primary mb-2 call-demo"><?php echo e(translate('save')); ?>

                                    </button>
                                </div>

                            </div>
                        </form>
                    <?php endif; ?>

                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/business-settings/chat-index.blade.php ENDPATH**/ ?>