<?php $__env->startSection('title', $category->parent_id == 0 ? translate('Update Category') : translate('Update Sub Category')); ?>)

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/category.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e($category->parent_id == 0 ? translate('Update Category') : translate('Update Sub Category')); ?>

                </span>
            </h2>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card card-body">
                    <form action="<?php echo e(route('admin.category.update',[$category['id']])); ?>" method="post"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                        <?php ($data = Helpers::get_business_settings('language')); ?>
                        <?php ($defaultLang = Helpers::get_default_language()); ?>

                        <?php if($data && array_key_exists('code', $data[0])): ?>
                            <ul class="nav nav-tabs w-fit-content mb-4">
                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="nav-item">
                                        <a class="nav-link lang_link <?php echo e($lang['default'] == true? 'active':''); ?>" href="#"
                                        id="<?php echo e($lang['code']); ?>-link"><?php echo e(\App\CentralLogics\Helpers::get_language_name($lang['code']).'('.strtoupper($lang['code']).')'); ?></a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="row align-items-end">
                                <div class="col-12">
                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        if (count($category['translations'])) {
                                            $translate = [];
                                            foreach ($category['translations'] as $t) {
                                                if ($t->locale == $lang['code'] && $t->key == "name") {
                                                    $translate[$lang['code']]['name'] = $t->value;
                                                }
                                            }
                                        }
                                        ?>
                                        <div class="form-group <?php echo e($lang['default'] == false ? 'd-none':''); ?> lang_form"
                                            id="<?php echo e($lang['code']); ?>-form">
                                            <label class="input-label"
                                                for="exampleFormControlInput1"><?php echo e(translate('name')); ?>

                                                (<?php echo e(strtoupper($lang['code'])); ?>)</label>
                                            <input type="text" name="name[]" maxlength="255"
                                                value="<?php echo e($lang['code'] == 'en' ? $category['name'] : ($translate[$lang['code']]['name']??'')); ?>"
                                                class="form-control" <?php if($lang['status'] == true): ?> oninvalid="document.getElementById('<?php echo e($lang['code']); ?>-link').click()" <?php endif; ?>
                                                placeholder="<?php echo e(translate('New Category')); ?>" <?php echo e($lang['status'] == true ? 'required':''); ?>>
                                        </div>
                                        <input type="hidden" name="lang[]" value="<?php echo e($lang['code']); ?>">
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <div class="row">
                                        <div class="col-6 mb-4">
                                            <div class="form-group lang_form" id="<?php echo e($defaultLang); ?>-form">
                                                <label class="input-label"
                                                    for="exampleFormControlInput1"><?php echo e(translate('name')); ?>

                                                    (<?php echo e(strtoupper($defaultLang)); ?>)</label>
                                                <input type="text" name="name[]" value="<?php echo e($category['name']); ?>"
                                                    class="form-control" oninvalid="document.getElementById('en-link').click()"
                                                    placeholder="<?php echo e(translate('New Category')); ?>" required>
                                            </div>
                                            <input type="hidden" name="lang[]" value="<?php echo e($defaultLang); ?>">
                                            <?php endif; ?>
                                            <input class="position-area" name="position" value="0">
                                        </div>
                                            <div class="col-md-6 mb-4">
                                                <div class="from_part_2 mt-2">
                                                    <div class="form-group">
                                                        <div class="text-center">
                                                            <img width="105" class="rounded-10 border" id="viewer"
                                                                src="<?php echo e($category->imageFullPath); ?>" alt="image" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="from_part_2">
                                                    <label><?php echo e(translate('category_Image')); ?></label>
                                                    <small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 1:1 )</small>
                                                    <div class="custom-file">
                                                        <input type="file" name="image" id="customFileEg1" class="custom-file-input"
                                                            accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*"
                                                            oninvalid="document.getElementById('en-link').click()">
                                                        <label class="custom-file-label" for="customFileEg1"><?php echo e(translate('choose file')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-6 mb-4">
                                                <div class="from_part_2">
                                                    <div class="form-group">
                                                        <div class="text-center max-h-200px overflow-hidden">
                                                            <img width="500" class="rounded-10 border" id="viewer2"
                                                                src="<?php echo e($category->bannerImageFullPath); ?>" alt="image" />
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="from_part_2">
                                                    <label><?php echo e(translate('banner image')); ?></label>
                                                    <small class="text-danger">* ( <?php echo e(translate('ratio')); ?> 8:1 )</small>
                                                    <div class="custom-file">
                                                        <input type="file" name="banner_image" id="customFileEg2" class="custom-file-input"
                                                            accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*"
                                                            oninvalid="document.getElementById('en-link').click()">
                                                        <label class="custom-file-label" for="customFileEg2"><?php echo e(translate('choose file')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                    </div>
                                    <div class="d-flex justify-content-end gap-3">
                                        <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                        <button type="submit" class="btn btn-primary"><?php echo e(translate('update')); ?></button>
                                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script>
        "use strict";

        function readURL(input, viewerId) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e) {
                    $('#' + viewerId).attr('src', e.target.result);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }

        $("#customFileEg1").change(function () {
            readURL(this, 'viewer');
        });

        $("#customFileEg2").change(function () {
            readURL(this, 'viewer2');
        });

        $(".lang_link").click(function(e){
            e.preventDefault();

            $(".lang_link").removeClass('active');
            $(".lang_form").addClass('d-none');
            $(this).addClass('active');

            let form_id = this.id;
            let lang = form_id.split("-")[0];

            $("#"+lang+"-form").removeClass('d-none');

            if(lang == '<?php echo e($defaultLang); ?>')
            {
                $(".from_part_2").removeClass('d-none');
            }
            else
            {
                $(".from_part_2").addClass('d-none');
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/admin-views/category/edit.blade.php ENDPATH**/ ?>