<!DOCTYPE html>
<?php
    $lang = \App\CentralLogics\Helpers::get_default_language();
    //$site_direction = \App\CentralLogics\Helpers::system_default_direction();
?>

<html lang="<?php echo e($lang); ?>" class="">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(translate('Email_Template')); ?></title>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,400;0,500;0,700;1,400&display=swap');

        body {
            margin: 0;
            font-family: 'Roboto', sans-serif;
            font-size: 13px;
            line-height: 21px;
            color: #737883;
            background-color: #e9ecef;
            padding: 0;
            display: flex;align-items: center;justify-content: center;
            min-height: 100vh;
        }
        h1,h2,h3,h4,h5,h6 {
            color: #334257;
            margin: 0;
        }
        * {
            box-sizing: border-box
        }

        :root {
            --base: #ffa726
        }

        .main-table {
            width: 500px;
            background: #FFFFFF;
            margin: 0 auto;
            padding: 40px;
        }
        .main-table-td {
        }
        img {
            max-width: 100%;
        }
        .cmn-btn{
            background: var(--base);
            color: #fff;
            padding: 8px 20px;
            display: inline-block;
            text-decoration: none;
        }
        .mb-1 {
            margin-bottom: 5px;
        }
        .mb-2 {
            margin-bottom: 10px;
        }
        .mb-3 {
            margin-bottom: 15px;
        }
        .mb-4 {
            margin-bottom: 20px;
        }
        .mb-5 {
            margin-bottom: 25px;
        }
        hr {
            border-color : rgba(0, 170, 109, 0.3);
            margin: 16px 0
        }
        .border-top {
            border-top: 1px solid rgba(0, 170, 109, 0.3);
            padding: 15px 0 10px;
            display: block;
        }
        .d-block {
            display: block;
        }
        .privacy {
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: center;
        }
        .privacy a {
            text-decoration: none;
            color: #334257;
            position: relative;
            margin-left: auto;
            margin-right: auto;
        }
        .privacy a span {
            width: 6px;
            height: 6px;
            border-radius: 50%;
            background: #334257;
            display: inline-block;
            margin: 0 7px;
        }
        .social {
            margin: 15px 0 8px;
            display: block;
        }
        .copyright{
            text-align: center;
            display: block;
        }
        div {
            display: block;
        }
        .text-center {
            text-align: center;
        }
        .text-base {
            color: var(--base);
            font-weight: 700
        }
        .font-medium {
            font-weight: 500;
        }
        .font-bold {
            font-weight: 700;
        }
        a {
            text-decoration: none;
        }
        .bg-section {
            background: #E3F5F1;
        }
        .p-10 {
            padding: 10px;
        }
        .mt-0{
            margin-top: 0;
        }
        .w-100 {
            width: 100%;
        }
        .order-table {
            padding: 10px;
            background: #fff;
        }
        .order-table tr td {
            vertical-align: top
        }
        .order-table .subtitle {
            margin: 0;
            margin-bottom: 10px;
        }
        .text-left {
            text-align: left;
        }
        .text-right {
            text-align: right;
        }
        .bg-section-2 {
            background: #F8F9FB;
        }
        .p-1 {
            padding: 5px;
        }
        .p-2 {
            padding: 10px;
        }
        .px-3 {
            padding-inline: 15px
        }
        .mb-0 {
            margin-bottom: 0;
        }
        .m-0 {
            margin: 0;
        }
        .text-base {
            color: var(--base);
            font-weight: 700
        }
        .mail-img-1 {
            width: 140px;
            height: 60px;
            object-fit: contain
        }
        .mail-img-2 {
            width: 130px;
            height: 45px;
            object-fit: contain
        }
        .mail-img-3 {
            width: 100%;
            height: 172px;
            object-fit: cover
        }
        .social img {
        width: 24px;
        }
    </style>

</head>


<body style="background-color: #e9ecef;padding:15px">


    <table dir="" class="main-table">
        <tbody>
            <tr>
                <td class="main-table-td">
                    <h2 class="mb-3" id="mail-title"><?php echo e($title?? translate('Main_Title_or_Subject_of_the_Mail')); ?></h2>
                    <div class="mb-1" id="mail-body"><?php echo $body?? translate('Hi_Sabrina,'); ?></div>
                    <span class="d-block text-center mb-3">
                        <?php if($data?->button_url): ?>
                        <a href="<?php echo e($data['button_url']??'#'); ?>" class="cmn-btn" id="mail-button"><?php echo e($data['button_name']??'Submit'); ?></a>
                        <?php endif; ?>                    </span>


                    <table class="bg-section p-10 w-100">
                        <tbody>
                        <tr>
                            <td class="p-10">
                                    <span class="d-block text-center">
                                        <?php ($restaurant_logo = \App\Model\BusinessSetting::where(['key' => 'logo'])->first()->value); ?>
                                        <img class="mb-2 mail-img-2" onerror="this.src='<?php echo e(asset('storage/app/public/restaurant/' . $restaurant_logo)); ?>'"
                                             src="<?php echo e(asset('storage/app/public/email_template/')); ?>/<?php echo e($data['logo']??''); ?>" alt="">
                                        <h3 class="mb-3 mt-0"><?php echo e(translate('Order_Info')); ?></h3>
                                    </span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <table class="order-table w-100">
                                    <tbody>
                                    <tr>
                                        <td>
                                            <h3 class="subtitle"><?php echo e(translate('Order_Summary')); ?></h3>
                                            <span class="d-block"><?php echo e(translate('Order')); ?># <?php echo e($order->id); ?></span>
                                            <span class="d-block"><?php echo e($order->created_at); ?></span>
                                        </td>













                                    </tr>
                                    <?php ($sub_total=0); ?>
                                    <?php ($total_tax=0); ?>
                                    <?php ($total_dis_on_pro=0); ?>
                                    <?php ($add_ons_cost=0); ?>
                                    <?php ($add_on_tax=0); ?>
                                    <?php ($add_ons_tax_cost=0); ?>

                                    <td colspan="2">
                                        <table class="w-100">
                                            <thead class="bg-section-2">
                                            <tr>
                                                <th class="text-left p-1 px-3"><?php echo e(translate('Product')); ?></th>
                                                <th class="text-right p-1 px-3"><?php echo e(translate('Price')); ?></th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php ($product_details = json_decode($detail['product_details'], true)); ?>
                                                <?php ($add_on_qtys=json_decode($detail['add_on_qtys'],true)); ?>
                                                <?php ($add_on_prices=json_decode($detail['add_on_prices'],true)); ?>
                                                <?php ($add_on_taxes=json_decode($detail['add_on_taxes'],true)); ?>

                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>
                                                    <td>
                                                        <div class="media gap-3 w-max-content">

                                                            <img class="img-fluid avatar avatar-lg"
                                                                 src="<?php echo e(asset('storage/app/public/product/')); ?>/<?php echo e($detail->product?->image); ?>"
                                                                 onerror="this.src='<?php echo e(asset('public/assets/admin/img/160x160/img2.jpg')); ?>'"
                                                                 alt="Image Description">

                                                            <div class="media-body text-dark fz-12">
                                                                
                                                                <h6 class="text-capitalize"><?php echo e($product_details['name']); ?></h6>
                                                                <div class="d-flex gap-2">
                                                                    <?php if(isset($detail['variation'])): ?>
                                                                        <?php $__currentLoopData = json_decode($detail['variation'],true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(isset($variation['name'])  && isset($variation['values'])): ?>
                                                                                <span class="d-block text-capitalize">
                                                                <strong><?php echo e($variation['name']); ?> -</strong>
                                                            </span>
                                                                                <?php $__currentLoopData = $variation['values']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                                                    <span class="d-block text-capitalize">
                                                                     <?php echo e($value['label']); ?> :
                                                                    <strong><?php echo e(\App\CentralLogics\Helpers::set_symbol( $value['optionPrice'])); ?></strong>
                                                                </span>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php else: ?>
                                                                                <?php if(isset(json_decode($detail['variation'],true)[0])): ?>
                                                                                    <strong><u> <?php echo e(translate('Variation')); ?> : </u></strong>
                                                                                    <?php $__currentLoopData = json_decode($detail['variation'],true)[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1 =>$variation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <div class="font-size-sm text-body">
                                                                                            <span><?php echo e($key1); ?> :  </span>
                                                                                            <span class="font-weight-bold"><?php echo e($variation); ?></span>
                                                                                        </div>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php endif; ?>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php else: ?>
                                                                        <div class="font-size-sm text-body">
                                                                            <span class="text-dark"><?php echo e(translate('price')); ?>  : <?php echo e(\App\CentralLogics\Helpers::set_symbol($detail['price'])); ?></span>
                                                                        </div>
                                                                    <?php endif; ?>

                                                                    <div class="d-flex gap-2">
                                                                        <span class=""><?php echo e(translate('Qty')); ?> :  </span>
                                                                        <span><?php echo e($detail['quantity']); ?></span>
                                                                    </div>

                                                                    <br>
                                                                    <?php ($addon_ids = json_decode($detail['add_on_ids'],true)); ?>
                                                                    <?php if($addon_ids): ?>
                                                                        <span>
                                                        <u><strong><?php echo e(translate('addons')); ?></strong></u>
                                                        <?php $__currentLoopData = $addon_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 =>$id): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <?php ($addon=\App\Model\AddOn::find($id)); ?>
                                                                                <?php ($add_on_qtys==null? $add_on_qty=1 : $add_on_qty=$add_on_qtys[$key2]); ?>

                                                                                <div class="font-size-sm text-body">
                                                                    <span><?php echo e($addon ? $addon['name'] : translate('addon deleted')); ?> :  </span>
                                                                    <span class="font-weight-semibold">
                                                                        <?php echo e($add_on_qty); ?> x <?php echo e(\App\CentralLogics\Helpers::set_symbol($add_on_prices[$key2])); ?> <br>
                                                                    </span>
                                                                </div>
                                                                                <?php ($add_ons_cost+=$add_on_prices[$key2] * $add_on_qty); ?>
                                                                                <?php ($add_ons_tax_cost +=  $add_on_taxes[$key2] * $add_on_qty); ?>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </span>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <?php ($amount=$detail['price']*$detail['quantity']); ?>
                                                        <?php echo e(\App\CentralLogics\Helpers::set_symbol($amount)); ?>

                                                    </td>
                                                    <td>
                                                        <?php ($tot_discount = $detail['discount_on_product']*$detail['quantity']); ?>
                                                        <?php echo e(\App\CentralLogics\Helpers::set_symbol($tot_discount)); ?>

                                                    </td>
                                                    <td>
                                                        <?php ($product_tax = $detail['tax_amount']*$detail['quantity']); ?>
                                                        <?php echo e(\App\CentralLogics\Helpers::set_symbol($product_tax + $add_ons_tax_cost)); ?>

                                                    </td>
                                                    <td class="text-right"><?php echo e(\App\CentralLogics\Helpers::set_symbol($amount-$tot_discount + $product_tax)); ?></td>
                                                </tr>
                                                <?php ($total_dis_on_pro += $tot_discount); ?>
                                                <?php ($sub_total += $amount); ?>
                                                <?php ($total_tax += $product_tax); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td colspan="2">
                                                    <hr class="mt-0">
                                                    <table class="w-100">
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('item_price')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($sub_total)); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('tax')); ?> / <?php echo e(translate('vat')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($total_tax)); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('addon')); ?> <?php echo e(translate('cost')); ?></td>

                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($add_ons_cost)); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('discount')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($total_dis_on_pro)); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('subtotal')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($sub_total =$sub_total+$total_tax+$add_ons_cost-$total_dis_on_pro + $add_ons_tax_cost)); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"><?php echo e(translate('coupon')); ?> <?php echo e(translate('discount')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($order['coupon_discount_amount'])); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"> <?php echo e(translate('extra discount')); ?></td>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($order['extra_discount'])); ?></td>
                                                        </tr>
                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3"> <?php echo e(translate('delivery fee')); ?></td>
                                                            <?php if($order['order_type']=='take_away'): ?>
                                                                <?php ($del_c=0); ?>
                                                            <?php else: ?>
                                                                <?php ($del_c=$order['delivery_charge']); ?>
                                                            <?php endif; ?>
                                                            <td class="text-right p-1 px-3"><?php echo e(\App\CentralLogics\Helpers::set_symbol($del_c)); ?></td>
                                                        </tr>

                                                        <tr>
                                                            <td style="width: 40%"></td>
                                                            <td class="p-1 px-3">
                                                                <h4><?php echo e(translate('total')); ?></h4>
                                                            </td>
                                                            <td class="text-right p-1 px-3">
                                                                <span class="text-base"><?php echo e(\App\CentralLogics\Helpers::set_symbol($sub_total - $order['coupon_discount_amount'] - $order['extra_discount'] + $del_c)); ?></span>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                                            </tr>
                                            </tbody>
                                        </table>
                                    </td>
                                    </tbody>
                                </table>
                            </td>
                        </tr>
                        </tbody>
                    </table>


                    <hr>
                    <div class="mb-2" id="mail-footer">
                        <?php echo e($footer_text ?? translate('Please_contact_us_for_any_queries,_we’re_always_happy_to_help.')); ?>

                    </div>
                    <div>
                        <?php echo e(translate('Thanks_&_Regards')); ?>,
                    </div>
                    <div class="mb-4">
                        <?php echo e($company_name); ?>

                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <span class="privacy">
                    <?php if(isset($data['privacy']) && $data['privacy'] == 1): ?>
                            <a href="<?php echo e(route('privacy-policy')); ?>" id="privacy-check"><?php echo e(translate('Privacy_Policy')); ?></a>
                        <?php endif; ?>
                        <?php if(isset($data['contact']) && $data['contact'] == 1): ?>
                            <a href="<?php echo e(route('about-us')); ?>" id="contact-check"><?php echo e(translate('About_Us')); ?></a>
                        <?php endif; ?>
                </span>
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    <span class="copyright" id="mail-copyright">
                        <?php echo e($copyright_text ?? translate('Copyright_2023_eFood._All_right_reserved')); ?>

                    </span>
                </td>
            </tr>
        </tbody>
    </table>


</body>
</html>
<?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/email-templates/new-email-format-3.blade.php ENDPATH**/ ?>