<?php $__env->startSection('title', translate('Promotional campaign')); ?>

<?php $__env->startSection('content'); ?>
    <div class="content container-fluid">
        <div class="d-flex flex-wrap gap-2 align-items-center mb-4">
            <h2 class="h1 mb-0 d-flex align-items-center gap-2">
                <img width="20" class="avatar-img" src="<?php echo e(asset('public/assets/admin/img/icons/promotion.png')); ?>" alt="">
                <span class="page-header-title">
                    <?php echo e(translate('promotion_Setup')); ?>

                </span>
            </h2>
        </div>

        <div class="row g-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('branch.promotion.store')); ?>" method="post" enctype="multipart/form-data" class="mb-0">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="input-label"><?php echo e(translate('Select_Banner_Type')); ?> <span class="text-danger">*</span></label>
                                        <select name="banner_type" id="banner_type" class="form-control js-select2-custom" required>
                                            <option value="" selected><?php echo e(translate('--Select--')); ?></option>
                                            <option value="bottom_banner"><?php echo e(translate('Bottom Banner (1110*380 px)')); ?></option>
                                            <option value="top_right_banner"><?php echo e(translate('Top Right Banner (280*450 px)')); ?></option>
                                            <option value="bottom_right_banner"><?php echo e(translate('Bottom Right Banner (280*350 px)')); ?></option>
                                            <option value="video"><?php echo e(translate('Video')); ?></option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <div class="col-12 from_part_2 video_section d--none" id="video_section">
                                            <label class="input-label"><?php echo e(translate('youtube_Video_URL')); ?> <span class="text-danger">*</span></label>
                                            <input type="text" name="video" class="form-control" placeholder="<?php echo e(translate('ex : https://youtu.be/0sus46BflpU')); ?>">
                                        </div>
                                        <div class="col-12 from_part_2 image_section d--none" id="image_section">
                                            <label class="input-label"><?php echo e(translate('Image')); ?> <span class="text-danger">*</span></label>
                                            <div class="custom-file">
                                                <input type="file" name="image" id="customFileEg" class="custom-file-input"
                                                    accept=".jpg, .png, .jpeg, .gif, .bmp, .tif, .tiff|image/*"
                                                    oninvalid="document.getElementById('en-link').click()">
                                                <label class="custom-file-label" for="customFileEg"><?php echo e(translate('choose file')); ?></label>
                                            </div>
                                            <div class="col-12 from_part_2 mt-2">
                                                <div class="form-group">
                                                    <div class="text-center">
                                                        <img class="promotion-image" id="viewer"
                                                            src="<?php echo e(asset('public/assets/admin/img/400x400/img2.jpg')); ?>" alt="image" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-end gap-3">
                                <button type="reset" class="btn btn-secondary"><?php echo e(translate('reset')); ?></button>
                                <button type="submit" class="btn btn-primary"><?php echo e(translate('Save')); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>


        <div class="card mt-3">
            <div class="card-top px-card pt-4">
                <div class="row justify-content-between align-items-center gy-2">
                    <div class="col-md-4">
                        <h5 class="d-flex align-items-center gap-2 mb-0">
                            <?php echo e(translate('Promotional_Campaign_Table')); ?>

                            <span class="badge badge-soft-dark rounded-50 fz-12"><?php echo e($promotions->total()); ?></span>
                        </h5>
                    </div>
                    <div class="col-md-4">
                        <div class="d-flex align-items-md-center gap-2 justify-content-md-center">
                            <?php echo e(translate('Promotion Status')); ?> :
                            <label class="switcher">
                                <input type="checkbox" class="switcher_input change-status"
                                        class="toggle-switch-input" <?php echo e($branch->branch_promotion_status?'checked':''); ?>>
                                <span class="switcher_control"></span>
                            </label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <form action="<?php echo e(url()->current()); ?>" method="GET">
                            <div class="input-group">
                                <input id="datatableSearch_" type="search" name="search"
                                        class="form-control"
                                        placeholder="<?php echo e(translate('Search')); ?>" aria-label="Search"
                                        value="<?php echo e($search); ?>" required autocomplete="off">
                                <div class="input-group-append">
                                    <button type="submit" class="btn btn-primary">
                                        <?php echo e(translate('Search')); ?>

                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <div class="py-4">
                <div class="table-responsive">
                    <table id="datatable" class="table table-hover table-borderless table-thead-bordered table-nowrap table-align-middle card-table">
                        <thead class="thead-light">
                            <tr>
                                <th><?php echo e(translate('SL')); ?></th>
                                <th><?php echo e(translate('Branch')); ?></th>
                                <th><?php echo e(translate('Promotion type')); ?></th>
                                <th><?php echo e(translate('Promotion Name')); ?></th>
                                <th class="text-center"><?php echo e(translate('action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $promotions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$promotion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th class="align-middle"><?php echo e($k+1); ?></th>
                                <td><?php echo e($promotion->branch->name); ?></td>
                                <td>
                                    <?php
                                        $promotion_type = $promotion['promotion_type'];
                                        echo str_replace('_', ' ', $promotion_type);
                                    ?>
                                </td>
                                <td>
                                    <?php if($promotion['promotion_type'] == 'video'): ?>
                                        <?php echo e($promotion['promotion_name']); ?>

                                    <?php else: ?>
                                        <div width="50">
                                            <img width="100" src="<?php echo e($promotion['PromotionNameFullPath']); ?>">
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="d-flex justify-content-center gap-2">
                                        <a href="<?php echo e(route('branch.promotion.edit',[$promotion['id']])); ?>"
                                            class="btn btn-outline-info btn-sm edit square-btn"
                                            title="<?php echo e(translate('Edit')); ?>">
                                            <i class="tio-edit"></i>
                                        </a>
                                        <a class="btn btn-outline-danger btn-sm edit square-btn form-alert" title="<?php echo e(translate('Delete')); ?>" href="javascript:"
                                           data-id="promotion-<?php echo e($promotion['id']); ?>"
                                           data-message="<?php echo e(translate('Want to delete this promotion ?')); ?>">
                                            <i class="tio-delete"></i>
                                        </a>
                                    </div>
                                    <form action="<?php echo e(route('branch.promotion.delete',[$promotion['id']])); ?>"
                                            method="post" id="promotion-<?php echo e($promotion['id']); ?>">
                                        <?php echo csrf_field(); ?> <?php echo method_field('delete'); ?>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>

                <div class="table-responsive mt-4 px-3">
                    <div class="d-flex justify-content-lg-end">
                        <?php echo e($promotions->links()); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script_2'); ?>
    <script src="<?php echo e(asset('public/assets/admin/js/branch-promotion.js')); ?>"></script>

    <script>
        $('.change-status').on('click', function(){
            location.href = '<?php echo e(route('branch.promotion.status',[$branch['id'],$branch->branch_promotion_status?0:1])); ?>';
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.branch.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/onlinegrocito/avantikabakers.com/main/resources/views/branch-views/branch_promotion/create.blade.php ENDPATH**/ ?>